import numpy as np

from matplotlib import pyplot as plt

# set the font to times new roman
plt.rcParams['font.family'] = 'Times New Roman'

def print_matrix_pixels(
        matrix,
        saveas='tmp',
        figsize=(5, 5),
        dpi=300,
        has_text=None,
        has_numbers=True,
        cmap='Blues',
        aspect='auto',
        scale=(1, 1),
        show=False,
        title=None,
        cluster_sizes=False,
        bbox_inches='tight'
):
    matrix = np.repeat(matrix, scale[0], axis=0)   # duplicate rows
    matrix = np.repeat(matrix, scale[1], axis=1)   # duplicate columns

    plt.figure(figsize=figsize)
    plt.imshow(matrix, cmap=cmap, interpolation='nearest',
               vmin=0, vmax=np.max(matrix), aspect=aspect)
    plt.axis('off')  # Turn off the axis
    if has_text:
        plt.text(52, 150,
                 str(has_text),
                 fontsize=36,
                 color='black',
                 bbox=dict(facecolor='green', alpha=0.33)
                 )

    if has_numbers:
        for i in range(matrix.shape[0]):
            for j in range(matrix.shape[1]):
                color = 'black'
                if matrix[i, j] >= 0.5:
                    color = 'white'

                plt.text(j, i, str(round(matrix[i, j], 2)),
                         ha='center', va='center', color=color, fontsize=30)

    if cluster_sizes:
        v_clusters_weights = cluster_sizes[0]
        c_clusters_weights = cluster_sizes[1]
        for i, w in enumerate(v_clusters_weights):
            plt.text(-0.9, i*scale[0], f'#{str(int(w))}', ha='center', va='center', color='black', fontsize=30)
        for i, w in enumerate(c_clusters_weights):
            plt.text(i*scale[1], -0.75, f'#{str(int(w))}', ha='center', va='center', color='black', fontsize=30)

    if title:
        plt.title(title, size=30)
    plt.savefig(f'images/{saveas}.png',  bbox_inches=bbox_inches, dpi=dpi)
    if show:
        plt.show()
    plt.close()



def print_matrix_pixels_with_names(
        matrix,
        saveas='tmp',
        figsize=(5, 5),
        dpi=300,
        has_text=None,
        cmap='Blues',
        aspect='auto',
        scale=(1, 1),
        show=False,
        names_C=None,
        weights_C=None,
        names_V=None,
        weights_V=None,
):
    matrix = np.repeat(matrix, scale[0], axis=0)   # duplicate rows
    matrix = np.repeat(matrix, scale[1], axis=1)   # duplicate columns

    plt.figure(figsize=figsize)
    plt.imshow(matrix, cmap=cmap, interpolation='nearest',
               vmin=0, vmax=np.max(matrix),
               aspect=aspect)
    plt.axis('off')  # Turn off the axis
    if has_text:
        plt.text(52, 150,
                 str(has_text),
                 fontsize=36,
                 color='black',
                 bbox=dict(facecolor='green', alpha=0.33)
                 )

    # write names on top of the clusters, where each cluster consists
    # of many columns (the exact values are in the names_weights)
    if names_C is not None:
        pos = 0
        for i, name in enumerate(names_C):
            plt.text(pos, -10,
                     str(name),
                     fontsize=16,
                     color='black',
                     rotation=90
                     )
            pos += weights_C[i]

    if names_V is not None:
        pos = 0
        for i, name in enumerate(names_V):
            plt.text(40, pos+30,
                     str(name),
                     fontsize=16,
                     color='black',
                     rotation=0
                     )
            pos += weights_V[i]

    plt.savefig(f'images/{saveas}.png', bbox_inches='tight', dpi=dpi)
    if show:
        plt.show()
    plt.close()

